/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.ui.cocoa.application.NSImage;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.AbstractLinkedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;
import org.rococoa.cocoa.foundation.NSSize;

public class IconCache {
    private static Logger log = Logger.getLogger(IconCache.class);
    private static IconCache instance = null;
    private static final Object lock = new Object();
    private Map<String, Map<Integer, NSImage>> cache = new LRUMap(Preferences.instance().getInteger("icon.cache.size")){

        protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing from cache:" + entry));
            }
            return true;
        }
    };
    private final NSRect NSZeroRect = new NSRect(0.0, 0.0);
    private static Local FOLDER_PATH = LocalFactory.createLocal((String)Preferences.instance().getProperty("application.support.path"));
    private final NSImage FOLDER_ICON = this.iconForPath(FOLDER_PATH);

    public static NSImage iconNamed(String name) {
        return IconCache.instance().iconForName(name);
    }

    public static NSImage iconNamed(String name, Integer size) {
        return IconCache.instance().iconForName(name, size);
    }

    public static NSImage iconNamed(String name, Integer width, Integer height) {
        return IconCache.instance().iconForName(name, width, height);
    }

    public static NSImage folderIcon(Integer size) {
        return IconCache.instance().iconForFolder(size);
    }

    public static NSImage documentIcon(String extension) {
        return IconCache.instance().iconForExtension(extension, null);
    }

    public static NSImage documentIcon(String extension, Integer size) {
        return IconCache.instance().iconForExtension(extension, size);
    }

    public static NSImage aliasIcon(String extension, Integer size) {
        return IconCache.instance().badge(IconCache.instance().iconForName("aliasbadge.png", size), IconCache.instance().iconForExtension(extension, size));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IconCache instance() {
        Object object = lock;
        synchronized (object) {
            if (null == instance) {
                instance = new IconCache();
            }
        }
        return instance;
    }

    private IconCache() {
    }

    private void put(String key, NSImage image, Integer size) {
        Map<Integer, NSImage> versions = this.cache.containsKey(key) ? this.cache.get(key) : new HashMap<Integer, NSImage>();
        versions.put(size, image);
        this.cache.put(key, versions);
    }

    private NSImage load(String key, Integer size) {
        if (!this.cache.containsKey(key)) {
            log.warn((Object)("No cached image for " + key));
            return null;
        }
        Map<Integer, NSImage> versions = this.cache.get(key);
        return versions.get(size);
    }

    public NSImage iconForExtension(String extension, Integer size) {
        NSImage img = this.load(extension, size);
        if (null == img) {
            img = NSWorkspace.sharedWorkspace().iconForFileType(extension);
            this.put(extension, this.convert(img, size), size);
        }
        return img;
    }

    public NSImage iconForExtension(NSImage badge, String extension, Integer size) {
        String name = extension + badge.name();
        NSImage icon = this.iconForName(name, size);
        if (null == icon) {
            icon = this.badge(badge, this.iconForExtension(extension, size));
            this.put(name, icon, size);
        }
        return icon;
    }

    public NSImage iconForFolder(Integer size) {
        NSImage folder = this.iconForName("NSFolder", size);
        if (null == folder) {
            return this.iconForPath(FOLDER_PATH, size);
        }
        return folder;
    }

    private NSImage iconForFolder(NSImage badge, Integer size) {
        String name = "NSFolder" + badge.name();
        NSImage folder = this.iconForName(name, size);
        if (null == folder) {
            folder = this.badge(badge, this.convert(this.FOLDER_ICON, size));
            this.put(name, folder, size);
        }
        return folder;
    }

    private NSImage badge(NSImage badge, NSImage icon) {
        NSImage f = NSImage.imageWithSize(icon.size());
        f.lockFocus();
        icon.drawInRect(new NSRect(new NSPoint(0.0, 0.0), icon.size()), this.NSZeroRect, 2, 1.0);
        badge.drawInRect(new NSRect(new NSPoint(0.0, 0.0), icon.size()), this.NSZeroRect, 2, 1.0);
        f.unlockFocus();
        return f;
    }

    protected NSImage iconForName(String name) {
        return this.iconForName(name, null);
    }

    protected NSImage iconForName(String name, Integer size) {
        return this.iconForName(name, size, size);
    }

    protected NSImage iconForName(String name, Integer width, Integer height) {
        NSImage image = this.load(name, width);
        if (null == image) {
            image = name.startsWith("/") ? NSImage.imageWithContentsOfFile(name) : NSImage.imageNamed(name);
            if (null == image) {
                log.warn((Object)("No icon named " + name));
                this.put(name, null, width);
            } else {
                image.setName(null);
                this.put(name, this.convert(image, width, height), width);
            }
        }
        return image;
    }

    public NSImage iconForPath(Local item) {
        return this.iconForPath(item, null);
    }

    public NSImage iconForPath(Local item, Integer size) {
        NSImage icon = null;
        if (item.exists() && null == (icon = this.load(item.getAbsolute(), size))) {
            icon = NSWorkspace.sharedWorkspace().iconForFile(item.getAbsolute());
            this.put(item.getAbsolute(), this.convert(icon, size), size);
        }
        if (null == icon) {
            return this.iconForName("notfound.tiff", size);
        }
        return icon;
    }

    public NSImage iconForApplication(String bundleIdentifier) {
        return this.iconForApplication(bundleIdentifier, null);
    }

    public NSImage iconForApplication(String bundleIdentifier, Integer size) {
        NSImage icon = this.load(bundleIdentifier, size);
        if (null == icon) {
            icon = NSWorkspace.sharedWorkspace().iconForFile(NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier(bundleIdentifier));
            this.put(bundleIdentifier, this.convert(icon, size), size);
        }
        if (null == icon) {
            return this.iconForName("notfound.tiff", size);
        }
        return icon;
    }

    public NSImage iconForPath(Path item, Integer size) {
        return this.iconForPath(item, size, Preferences.instance().getBoolean("browser.markInaccessibleFolders"));
    }

    public NSImage iconForPath(Path item, Integer size, boolean overlay) {
        if (item.attributes().isSymbolicLink()) {
            NSImage badge = this.iconForName("aliasbadge.png", size);
            if (item.attributes().isDirectory()) {
                return this.iconForFolder(badge, size);
            }
            return this.iconForExtension(badge, item.getExtension(), size);
        }
        if (item.attributes().isFile()) {
            if (StringUtils.isEmpty((String)item.getExtension()) && item.attributes().getPermission().isExecutable()) {
                return this.iconForName("executable.tiff", size);
            }
            return this.iconForExtension(item.getExtension(), size);
        }
        if (item.attributes().isVolume()) {
            return this.iconForName(item.getHost().getProtocol().disk(), size);
        }
        if (item.attributes().isDirectory()) {
            if (overlay) {
                if (!item.attributes().getPermission().isExecutable() || item.isCached() && !item.cache().get(item.getReference()).attributes().isReadable()) {
                    NSImage badge = this.iconForName("privatefolderbadge.png", size);
                    return this.iconForFolder(badge, size);
                }
                if (!item.attributes().getPermission().isReadable() && item.attributes().getPermission().isWritable()) {
                    NSImage badge = this.iconForName("dropfolderbadge.png", size);
                    return this.iconForFolder(badge, size);
                }
                if (!item.attributes().getPermission().isWritable()) {
                    NSImage badge = this.iconForName("readonlyfolderbadge.png", size);
                    return this.iconForFolder(badge, size);
                }
            }
            return this.iconForFolder(size);
        }
        return this.iconForName("notfound.tiff", size);
    }

    public NSImage convert(NSImage icon, Integer size) {
        return this.convert(icon, size, size);
    }

    public NSImage convert(NSImage icon, Integer width, Integer height) {
        if (null == width || null == height) {
            log.info((Object)("Return default size for " + icon.name()));
            return icon;
        }
        icon.setSize(new NSSize(width.intValue(), height.intValue()));
        return icon;
    }
}

