/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.threading.BackgroundException;
import ch.cyberduck.ui.cocoa.BundleController;
import ch.cyberduck.ui.cocoa.TaskController;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.application.NSView;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import org.apache.log4j.Logger;

public class ErrorController
extends BundleController {
    private static Logger log = Logger.getLogger(TaskController.class);
    private NSTextField hostField;
    private NSTextField descriptionField;
    private NSTextField errorField;
    private NSView view;
    private BackgroundException failure;

    public void setHostField(NSTextField hostField) {
        this.hostField = hostField;
        if (null == this.failure.getPath()) {
            this.hostField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(this.failure.getSession().getHost().toURL(), FIXED_WITH_FONT_ATTRIBUTES));
        } else {
            this.hostField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(this.failure.getPath().getAbsolute(), FIXED_WITH_FONT_ATTRIBUTES));
        }
    }

    public void setDescriptionField(NSTextField descriptionField) {
        this.descriptionField = descriptionField;
        this.descriptionField.setSelectable(true);
        this.descriptionField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(this.failure.getDetailedCauseMessage(), TRUNCATE_MIDDLE_ATTRIBUTES));
    }

    public void setErrorField(NSTextField errorField) {
        this.errorField = errorField;
        this.errorField.setSelectable(true);
        this.errorField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(this.failure.getReadableTitle() + ": " + this.failure.getMessage(), TRUNCATE_MIDDLE_ATTRIBUTES));
    }

    public void setView(NSView view) {
        this.view = view;
    }

    public NSView view() {
        return this.view;
    }

    public ErrorController(BackgroundException e) {
        this.failure = e;
        this.loadBundle();
    }

    public String getTooltip() {
        return this.failure.getReadableTitle();
    }

    protected String getBundleName() {
        return "Error";
    }
}

