/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.DateFormatterFactory;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.FileController;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.WindowController;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.odb.EditorFactory;
import java.text.MessageFormat;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class DuplicateFileController
extends FileController {
    public DuplicateFileController(WindowController parent) {
        super(parent, NSAlert.alert(Locale.localizedString((String)"Duplicate File", (String)"Duplicate"), Locale.localizedString((String)"Enter the name for the new file:", (String)"Duplicate"), Locale.localizedString((String)"Duplicate", (String)"Duplicate"), EditorFactory.defaultEditor() != null ? Locale.localizedString((String)"Edit", (String)"Duplicate") : null, Locale.localizedString((String)"Cancel", (String)"Duplicate")));
        this.alert.setIcon(IconCache.instance().iconForExtension(this.getSelected().getExtension(), 64));
        Path selected = this.getSelected();
        String proposal = MessageFormat.format(Preferences.instance().getProperty("browser.duplicate.format"), FilenameUtils.getBaseName((String)selected.getName()), DateFormatterFactory.instance().getShortFormat(System.currentTimeMillis(), false).replace('/', ':'), StringUtils.isNotEmpty((String)selected.getExtension()) ? "." + selected.getExtension() : "");
        this.filenameField.setStringValue(proposal);
    }

    public void callback(int returncode) {
        if (returncode == 1) {
            this.duplicateFile(this.getSelected(), this.filenameField.stringValue(), false);
        } else if (returncode == 0) {
            this.duplicateFile(this.getSelected(), this.filenameField.stringValue(), true);
        }
    }

    protected Path getWorkdir() {
        return this.getSelected().getParent();
    }

    private void duplicateFile(Path selected, String filename, boolean edit) {
        Path duplicate = PathFactory.createPath((Session)this.getSession(), (String)selected.getParent().getAbsolute(), (String)filename, (int)selected.attributes().getType());
        ((BrowserController)this.parent).duplicatePath(selected, duplicate, edit);
    }
}

