/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.FileController;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.WindowController;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.threading.BrowserBackgroundAction;
import java.text.MessageFormat;
import java.util.Collections;
import org.apache.commons.io.FilenameUtils;

public class CreateSymlinkController
extends FileController {
    public CreateSymlinkController(WindowController parent) {
        super(parent, NSAlert.alert(Locale.localizedString((String)"Create new symbolic link", (String)"File"), "", Locale.localizedString((String)"Create", (String)"File"), null, Locale.localizedString((String)"Cancel", (String)"File")));
        this.alert.setIcon(IconCache.aliasIcon(null, 64));
        Path selected = this.getSelected();
        this.filenameField.setStringValue(FilenameUtils.getBaseName((String)selected.getName()));
        this.setMessage(MessageFormat.format(Locale.localizedString((String)"Enter the name for the new symbolic link for {0}:", (String)"File"), selected.getName()));
    }

    public void callback(int returncode) {
        if (returncode == 1) {
            this.createSymlink(this.getSelected(), this.filenameField.stringValue(), false);
        }
    }

    protected void createSymlink(final Path selected, final String symlink, boolean edit) {
        final BrowserController c = (BrowserController)this.parent;
        final Path link = PathFactory.createPath((Session)this.getSession(), (String)this.getWorkdir().getAbsolute(), (String)symlink, (int)1);
        c.background((BackgroundAction)new BrowserBackgroundAction(c){

            public void run() {
                link.symlink(selected.getName());
            }

            public String getActivity() {
                return MessageFormat.format(Locale.localizedString((String)"Uploading {0}", (String)"Status"), symlink);
            }

            public void cleanup() {
                if (symlink.charAt(0) == '.') {
                    c.setShowHiddenFiles(true);
                }
                c.reloadData(Collections.singletonList(link));
            }
        });
    }
}

