/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.ui.cocoa.ProxyController;
import ch.cyberduck.ui.cocoa.TableCellAttributes;
import ch.cyberduck.ui.cocoa.application.AppKitFunctions;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.application.NSFont;
import ch.cyberduck.ui.cocoa.application.NSView;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSBundle;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSURL;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class BundleController
extends ProxyController {
    private static Logger log = Logger.getLogger(BundleController.class);
    public static final NSDictionary TRUNCATE_MIDDLE_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObject(TableCellAttributes.PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_MIDDLE), NSArray.arrayWithObject("NSParagraphStyle"));
    public static final NSDictionary FIXED_WITH_FONT_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObject(NSFont.userFixedPitchFontOfSize(9.0)), NSArray.arrayWithObject("NSFont"));
    private boolean awaked;

    protected void loadBundle() {
        String bundleName = this.getBundleName();
        if (null == bundleName) {
            log.debug((Object)("No bundle to load for " + ((Object)((Object)this)).toString()));
            return;
        }
        this.loadBundle(bundleName);
    }

    protected void loadBundle(String bundleName) {
        if (this.awaked) {
            log.warn((Object)("Bundle " + bundleName + " already loaded"));
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Loading bundle " + bundleName));
        }
        if (!NSBundle.loadNibNamed(bundleName, this.id())) {
            log.fatal((Object)("Couldn't load " + bundleName + ".nib"));
            return;
        }
        if (!this.awaked) {
            this.awakeFromNib();
        }
    }

    public void awakeFromNib() {
        log.debug((Object)"awakeFromNib");
        this.awaked = true;
    }

    protected NSView view() {
        return null;
    }

    protected abstract String getBundleName();

    public static void openUrl(AbstractPath.DescriptiveUrl url) {
        BundleController.openUrl(url.getUrl());
    }

    public static void openUrl(String url) {
        if (StringUtils.isNotBlank((String)url)) {
            if (!NSWorkspace.sharedWorkspace().openURL(NSURL.URLWithString(url))) {
                AppKitFunctions.instance.NSBeep();
            }
        } else {
            AppKitFunctions.instance.NSBeep();
        }
    }

    protected int alert(NSAlert alert) {
        return alert.runModal();
    }
}

