/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractCollectionListener;
import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.ftp.FTPConnectMode;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.AbstractBackgroundAction;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.MainController;
import ch.cyberduck.ui.cocoa.WindowController;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSColor;
import ch.cyberduck.ui.cocoa.application.NSFont;
import ch.cyberduck.ui.cocoa.application.NSImage;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.application.NSOpenPanel;
import ch.cyberduck.ui.cocoa.application.NSPopUpButton;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.application.NSTextFieldCell;
import ch.cyberduck.ui.cocoa.application.NSTextView;
import ch.cyberduck.ui.cocoa.application.NSWindow;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSData;
import ch.cyberduck.ui.cocoa.foundation.NSEnumerator;
import ch.cyberduck.ui.cocoa.foundation.NSMutableAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSNotificationCenter;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSURL;
import ch.cyberduck.ui.cocoa.util.HyperlinkAttributedStringFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;
import org.spearce.jgit.transport.OpenSshConfig;

public class BookmarkController
extends WindowController {
    private static Logger log = Logger.getLogger(BookmarkController.class);
    private NSPopUpButton protocolPopup;
    private NSPopUpButton encodingPopup;
    private NSTextField nicknameField;
    private NSTextField hostField;
    private NSButton alertIcon;
    private NSTextField portField;
    private NSTextField pathField;
    private NSTextField urlField;
    private NSTextField usernameField;
    private NSButton anonymousCheckbox;
    private NSTextField webURLField;
    private NSButton webUrlImage;
    private NSImage favicon;
    private NSTextView commentField;
    protected static final String AUTO = Locale.localizedString((String)"Auto");
    private NSPopUpButton timezonePopup;
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final String TIMEZONE_ID_PREFIXES = "^(Africa|America|Asia|Atlantic|Australia|Europe|Indian|Pacific)/.*";
    private NSPopUpButton connectmodePopup;
    private static final String CONNECTMODE_ACTIVE = Locale.localizedString((String)"Active");
    private static final String CONNECTMODE_PASSIVE = Locale.localizedString((String)"Passive");
    private NSPopUpButton transferPopup;
    private static final String TRANSFER_NEWCONNECTION = Locale.localizedString((String)"Open new connection");
    private static final String TRANSFER_BROWSERCONNECTION = Locale.localizedString((String)"Use browser connection");
    private NSPopUpButton downloadPathPopup;
    private static final String CHOOSE = Locale.localizedString((String)"Choose") + "\u2026";
    private NSOpenPanel downloadPathPanel;
    private NSButton toggleOptionsButton;
    private Host host;
    private final AbstractCollectionListener<Host> bookmarkCollectionListener = new AbstractCollectionListener<Host>(){

        public void collectionItemRemoved(Host item) {
            NSWindow window;
            if (item.equals((Object)BookmarkController.this.host) && null != (window = BookmarkController.this.window())) {
                window.close();
            }
        }
    };
    private NSTextField pkLabel;
    private NSButton pkCheckbox;
    private NSOpenPanel publicKeyPanel;

    public void setProtocolPopup(NSPopUpButton protocolPopup) {
        this.protocolPopup = protocolPopup;
        this.protocolPopup.setEnabled(true);
        this.protocolPopup.setTarget(this.id());
        this.protocolPopup.setAction(Foundation.selector("protocolSelectionChanged:"));
        this.protocolPopup.removeAllItems();
        for (Protocol protocol : ProtocolFactory.getKnownProtocols()) {
            String title = protocol.getDescription();
            this.protocolPopup.addItemWithTitle(title);
            NSMenuItem item = this.protocolPopup.itemWithTitle(title);
            item.setRepresentedObject(protocol.getIdentifier());
            item.setImage(IconCache.iconNamed(protocol.icon(), 16));
        }
    }

    public void protocolSelectionChanged(NSPopUpButton sender) {
        String member;
        log.debug((Object)("protocolSelectionChanged:" + sender));
        Protocol selected = ProtocolFactory.forName((String)this.protocolPopup.selectedItem().representedObject());
        this.host.setPort(selected.getDefaultPort());
        if (!this.host.getProtocol().isHostnameConfigurable()) {
            this.host.setHostname(selected.getDefaultHostname());
        }
        if (!selected.isHostnameConfigurable()) {
            this.host.setHostname(selected.getDefaultHostname());
        }
        if (StringUtils.isNotBlank((String)selected.getDefaultHostname())) {
            this.host.setHostname(selected.getDefaultHostname());
        }
        if (!selected.isWebUrlConfigurable()) {
            this.host.setWebURL(null);
        }
        if (selected.equals((Object)Protocol.IDISK) && StringUtils.isNotEmpty((String)(member = Preferences.instance().getProperty("iToolsMember")))) {
            this.host.getCredentials().setUsername(member);
            this.host.setDefaultPath(String.valueOf('/') + member);
        }
        this.host.setProtocol(selected);
        this.readOpenSshConfiguration();
        this.itemChanged();
        this.init();
        this.reachable();
    }

    private void readOpenSshConfiguration() {
        if (this.host.getProtocol().equals((Object)Protocol.SFTP)) {
            OpenSshConfig.Host entry = OpenSshConfig.create().lookup(this.host.getHostname());
            if (null != entry.getIdentityFile()) {
                this.host.getCredentials().setIdentity(LocalFactory.createLocal((String)entry.getIdentityFile().getAbsolutePath()));
            }
            if (StringUtils.isNotBlank((String)entry.getUser())) {
                this.host.getCredentials().setUsername(entry.getUser());
            }
        } else {
            this.host.getCredentials().setIdentity(null);
        }
    }

    public void setEncodingPopup(NSPopUpButton encodingPopup) {
        this.encodingPopup = encodingPopup;
        this.encodingPopup.setEnabled(true);
        this.encodingPopup.removeAllItems();
        this.encodingPopup.addItemWithTitle(DEFAULT);
        this.encodingPopup.menu().addItem(NSMenuItem.separatorItem());
        this.encodingPopup.addItemsWithTitles(NSArray.arrayWithObjects(MainController.availableCharsets()));
        if (null == this.host.getEncoding()) {
            this.encodingPopup.selectItemWithTitle(DEFAULT);
        } else {
            this.encodingPopup.selectItemWithTitle(this.host.getEncoding());
        }
        this.encodingPopup.setTarget(this.id());
        Selector action = Foundation.selector("encodingSelectionChanged:");
        this.encodingPopup.setAction(action);
    }

    public void encodingSelectionChanged(NSPopUpButton sender) {
        log.debug((Object)("encodingSelectionChanged:" + sender));
        if (sender.selectedItem().title().equals(DEFAULT)) {
            this.host.setEncoding(null);
        } else {
            this.host.setEncoding(sender.selectedItem().title());
        }
        this.itemChanged();
    }

    public void setNicknameField(NSTextField nicknameField) {
        this.nicknameField = nicknameField;
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("nicknameInputDidChange:"), "NSControlTextDidChangeNotification", this.nicknameField);
    }

    public void setHostField(NSTextField hostField) {
        this.hostField = hostField;
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("hostFieldDidChange:"), "NSControlTextDidChangeNotification", hostField);
    }

    public void setAlertIcon(NSButton alertIcon) {
        this.alertIcon = alertIcon;
        this.alertIcon.setEnabled(false);
        this.alertIcon.setImage(null);
        this.alertIcon.setTarget(this.id());
        this.alertIcon.setAction(Foundation.selector("launchNetworkAssistant:"));
    }

    public void launchNetworkAssistant(NSButton sender) {
        this.host.diagnose();
    }

    public void setPortField(NSTextField portField) {
        this.portField = portField;
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("portInputDidEndEditing:"), "NSControlTextDidChangeNotification", this.portField);
    }

    public void setPathField(NSTextField pathField) {
        this.pathField = pathField;
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("pathInputDidChange:"), "NSControlTextDidChangeNotification", this.pathField);
    }

    public void setUrlField(NSTextField urlField) {
        this.urlField = urlField;
        this.urlField.setAllowsEditingTextAttributes(true);
        this.urlField.setSelectable(true);
    }

    public void setUsernameField(NSTextField usernameField) {
        this.usernameField = usernameField;
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("usernameInputDidChange:"), "NSControlTextDidChangeNotification", this.usernameField);
    }

    public void setAnonymousCheckbox(NSButton anonymousCheckbox) {
        this.anonymousCheckbox = anonymousCheckbox;
        this.anonymousCheckbox.setTarget(this.id());
        this.anonymousCheckbox.setAction(Foundation.selector("anonymousCheckboxClicked:"));
        this.anonymousCheckbox.setState(0);
    }

    public void setWebURLField(NSTextField webURLField) {
        this.webURLField = webURLField;
        NSTextFieldCell cell = this.webURLField.cell();
        cell.setPlaceholderString(this.host.getDefaultWebURL());
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("webURLInputDidChange:"), "NSControlTextDidChangeNotification", this.webURLField);
    }

    public void setWebUrlImage(NSButton b) {
        this.webUrlImage = b;
        this.webUrlImage.setTarget(this.id());
        this.webUrlImage.setAction(Foundation.selector("openWebUrl:"));
        this.webUrlImage.setImage(IconCache.iconNamed("site.tiff", 16));
    }

    private void updateFavicon() {
        if (Preferences.instance().getBoolean("bookmark.favicon.download")) {
            this.background((BackgroundAction)new AbstractBackgroundAction(){

                public void run() {
                    NSImage img;
                    String f = BookmarkController.this.host.getProtocol().favicon();
                    if (StringUtils.isNotBlank((String)f)) {
                        img = IconCache.iconNamed(f, 16);
                    } else {
                        String url = BookmarkController.this.host.getWebURL() + "/favicon.ico";
                        NSData data = NSData.dataWithContentsOfURL(NSURL.URLWithString(url));
                        if (null == data) {
                            return;
                        }
                        img = NSImage.imageWithData(data);
                    }
                    if (null == img) {
                        return;
                    }
                    BookmarkController.this.favicon = IconCache.instance().convert(img, 16);
                }

                public void cleanup() {
                    if (null == BookmarkController.this.favicon) {
                        return;
                    }
                    BookmarkController.this.webUrlImage.setImage(BookmarkController.this.favicon);
                }

                public Object lock() {
                    return BookmarkController.this;
                }
            });
        }
    }

    public void openWebUrl(NSButton sender) {
        BookmarkController.openUrl(this.host.getWebURL());
    }

    public void setCommentField(NSTextView commentField) {
        this.commentField = commentField;
        this.commentField.setFont(NSFont.userFixedPitchFontOfSize(11.0));
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("commentInputDidChange:"), "NSTextDidChangeNotification", this.commentField);
    }

    public void setTimezonePopup(NSPopUpButton timezonePopup) {
        this.timezonePopup = timezonePopup;
        this.timezonePopup.setTarget(this.id());
        this.timezonePopup.setAction(Foundation.selector("timezonePopupClicked:"));
        this.timezonePopup.removeAllItems();
        this.timezonePopup.addItemWithTitle(UTC.getID());
        this.timezonePopup.menu().addItem(NSMenuItem.separatorItem());
        List<String> timezones = Arrays.asList(TimeZone.getAvailableIDs());
        Collections.sort(timezones, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return TimeZone.getTimeZone(o1).getID().compareTo(TimeZone.getTimeZone(o2).getID());
            }
        });
        for (String tz : timezones) {
            if (!tz.matches(TIMEZONE_ID_PREFIXES)) continue;
            this.timezonePopup.addItemWithTitle(TimeZone.getTimeZone(tz).getID());
        }
    }

    public void timezonePopupClicked(NSPopUpButton sender) {
        String selected = sender.selectedItem().title();
        if (selected.equals(AUTO)) {
            this.host.setTimezone(null);
        } else {
            String[] ids;
            for (String id : ids = TimeZone.getAvailableIDs()) {
                TimeZone tz = TimeZone.getTimeZone(id);
                if (!tz.getID().equals(selected)) continue;
                this.host.setTimezone(tz);
                break;
            }
        }
        this.itemChanged();
    }

    public void setConnectmodePopup(NSPopUpButton connectmodePopup) {
        this.connectmodePopup = connectmodePopup;
        this.connectmodePopup.setTarget(this.id());
        this.connectmodePopup.setAction(Foundation.selector("connectmodePopupClicked:"));
        this.connectmodePopup.removeAllItems();
        this.connectmodePopup.addItemWithTitle(DEFAULT);
        this.connectmodePopup.menu().addItem(NSMenuItem.separatorItem());
        this.connectmodePopup.addItemWithTitle(CONNECTMODE_ACTIVE);
        this.connectmodePopup.addItemWithTitle(CONNECTMODE_PASSIVE);
    }

    public void connectmodePopupClicked(NSPopUpButton sender) {
        if (sender.selectedItem().title().equals(DEFAULT)) {
            this.host.setFTPConnectMode(null);
        } else if (sender.selectedItem().title().equals(CONNECTMODE_ACTIVE)) {
            this.host.setFTPConnectMode(FTPConnectMode.PORT);
        } else if (sender.selectedItem().title().equals(CONNECTMODE_PASSIVE)) {
            this.host.setFTPConnectMode(FTPConnectMode.PASV);
        }
        this.itemChanged();
    }

    public void setTransferPopup(NSPopUpButton transferPopup) {
        this.transferPopup = transferPopup;
        this.transferPopup.setTarget(this.id());
        this.transferPopup.setAction(Foundation.selector("transferPopupClicked:"));
        this.transferPopup.removeAllItems();
        this.transferPopup.addItemWithTitle(DEFAULT);
        this.transferPopup.menu().addItem(NSMenuItem.separatorItem());
        this.transferPopup.addItemWithTitle(TRANSFER_NEWCONNECTION);
        this.transferPopup.addItemWithTitle(TRANSFER_BROWSERCONNECTION);
    }

    public void transferPopupClicked(NSPopUpButton sender) {
        if (sender.selectedItem().title().equals(DEFAULT)) {
            this.host.setMaxConnections(null);
        } else if (sender.selectedItem().title().equals(TRANSFER_BROWSERCONNECTION)) {
            this.host.setMaxConnections(Integer.valueOf(1));
        } else if (sender.selectedItem().title().equals(TRANSFER_NEWCONNECTION)) {
            this.host.setMaxConnections(Integer.valueOf(-1));
        }
        this.itemChanged();
    }

    public void setDownloadPathPopup(NSPopUpButton downloadPathPopup) {
        this.downloadPathPopup = downloadPathPopup;
        this.downloadPathPopup.setTarget(this.id());
        Selector action = Foundation.selector("downloadPathPopupClicked:");
        this.downloadPathPopup.setAction(action);
        this.downloadPathPopup.removeAllItems();
        this.addDownloadPath(action, this.host.getDownloadFolder());
        this.downloadPathPopup.menu().addItem(NSMenuItem.separatorItem());
        this.addDownloadPath(action, LocalFactory.createLocal((String)Preferences.instance().getProperty("queue.download.folder")));
        this.addDownloadPath(action, LocalFactory.createLocal((String)"~/Desktop"));
        this.addDownloadPath(action, LocalFactory.createLocal((String)"~"));
        this.addDownloadPath(action, LocalFactory.createLocal((String)"~/Downloads"));
        this.downloadPathPopup.menu().addItem(NSMenuItem.separatorItem());
        this.downloadPathPopup.menu().addItemWithTitle_action_keyEquivalent(CHOOSE, action, "");
        this.downloadPathPopup.lastItem().setTarget(this.id());
    }

    private void addDownloadPath(Selector action, Local f) {
        if (this.downloadPathPopup.menu().itemWithTitle(f.getDisplayName()) == null) {
            this.downloadPathPopup.menu().addItemWithTitle_action_keyEquivalent(f.getDisplayName(), action, "");
            this.downloadPathPopup.lastItem().setTarget(this.id());
            this.downloadPathPopup.lastItem().setImage(IconCache.instance().iconForPath(f, (Integer)16));
            this.downloadPathPopup.lastItem().setRepresentedObject(f.getAbsolute());
            if (this.host.getDownloadFolder().equals((Object)f)) {
                this.downloadPathPopup.selectItem(this.downloadPathPopup.lastItem());
            }
        }
    }

    public void downloadPathPopupClicked(NSMenuItem sender) {
        if (sender.title().equals(CHOOSE)) {
            this.downloadPathPanel = NSOpenPanel.openPanel();
            this.downloadPathPanel.setCanChooseFiles(false);
            this.downloadPathPanel.setCanChooseDirectories(true);
            this.downloadPathPanel.setAllowsMultipleSelection(false);
            this.downloadPathPanel.setCanCreateDirectories(true);
            this.downloadPathPanel.beginSheetForDirectory(null, null, this.window, this.id(), Foundation.selector("downloadPathPanelDidEnd:returnCode:contextInfo:"), null);
        } else {
            this.host.setDownloadFolder(sender.representedObject());
            this.itemChanged();
        }
    }

    public void downloadPathPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
        NSArray selected;
        if (returncode == 1 && (selected = sheet.filenames()).lastObject() != null) {
            this.host.setDownloadFolder(selected.lastObject().toString());
        }
        this.downloadPathPopup.itemAtIndex(new NSInteger(0L)).setTitle(this.host.getDownloadFolder().getDisplayName());
        this.downloadPathPopup.itemAtIndex(new NSInteger(0L)).setRepresentedObject(this.host.getDownloadFolder().getAbsolute());
        this.downloadPathPopup.itemAtIndex(new NSInteger(0L)).setImage(IconCache.instance().iconForPath(this.host.getDownloadFolder(), (Integer)16));
        this.downloadPathPopup.selectItemAtIndex(new NSInteger(0L));
        this.downloadPathPanel = null;
        this.itemChanged();
    }

    public void setToggleOptionsButton(NSButton toggleOptionsButton) {
        this.toggleOptionsButton = toggleOptionsButton;
    }

    private BookmarkController(Host host) {
        this.host = host;
        BookmarkCollection.defaultCollection().addListener(this.bookmarkCollectionListener);
        this.loadBundle();
    }

    protected void invalidate() {
        Preferences.instance().setProperty("bookmark.toggle.options", this.toggleOptionsButton.state());
        BookmarkCollection.defaultCollection().removeListener(this.bookmarkCollectionListener);
        super.invalidate();
    }

    protected String getBundleName() {
        return "Bookmark";
    }

    public void awakeFromNib() {
        this.cascade();
        this.init();
        this.setState(this.toggleOptionsButton, Preferences.instance().getBoolean("bookmark.toggle.options"));
        this.reachable();
        this.updateFavicon();
        super.awakeFromNib();
    }

    protected double getMaxWindowHeight() {
        return this.window.frame().size.height.doubleValue();
    }

    protected double getMaxWindowWidth() {
        return 600.0;
    }

    public void setPkLabel(NSTextField pkLabel) {
        this.pkLabel = pkLabel;
    }

    public void setPkCheckbox(NSButton pkCheckbox) {
        this.pkCheckbox = pkCheckbox;
        this.pkCheckbox.setTarget(this.id());
        this.pkCheckbox.setAction(Foundation.selector("pkCheckboxSelectionChanged:"));
    }

    public void pkCheckboxSelectionChanged(NSButton sender) {
        log.debug((Object)"pkCheckboxSelectionChanged");
        if (sender.state() == 1) {
            this.publicKeyPanel = NSOpenPanel.openPanel();
            this.publicKeyPanel.setCanChooseDirectories(false);
            this.publicKeyPanel.setCanChooseFiles(true);
            this.publicKeyPanel.setAllowsMultipleSelection(false);
            this.publicKeyPanel.setMessage(Locale.localizedString((String)"Select the private key in PEM or PuTTY format", (String)"Credentials"));
            this.publicKeyPanel.setPrompt(Locale.localizedString((String)"Choose"));
            this.publicKeyPanel.beginSheetForDirectory(LocalFactory.createLocal((String)"~/.ssh").getAbsolute(), null, this.window(), this.id(), Foundation.selector("pkSelectionPanelDidEnd:returnCode:contextInfo:"), null);
        } else {
            this.pkSelectionPanelDidEnd_returnCode_contextInfo(this.publicKeyPanel, 0, null);
        }
    }

    public void pkSelectionPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
        log.debug((Object)"pkSelectionPanelDidEnd");
        if (returncode == 1) {
            NSObject next;
            NSArray selected = sheet.filenames();
            NSEnumerator enumerator = selected.objectEnumerator();
            while ((next = enumerator.nextObject()) != null) {
                this.host.getCredentials().setIdentity(LocalFactory.createLocal((String)next.toString()));
            }
        }
        if (returncode == 0) {
            this.host.getCredentials().setIdentity(null);
        }
        this.init();
        this.itemChanged();
    }

    public void hostFieldDidChange(NSNotification sender) {
        String input = this.hostField.stringValue();
        if (ProtocolFactory.isURL((String)input)) {
            this.host.init(Host.parse((String)input).getAsDictionary());
        } else {
            this.host.setHostname(input);
        }
        this.readOpenSshConfiguration();
        this.itemChanged();
        this.init();
        this.reachable();
    }

    private void reachable() {
        if (StringUtils.isNotBlank((String)this.host.getHostname())) {
            this.background((BackgroundAction)new AbstractBackgroundAction(){
                boolean reachable = false;

                public void run() {
                    this.reachable = BookmarkController.this.host.isReachable();
                }

                public void cleanup() {
                    BookmarkController.this.alertIcon.setEnabled(!this.reachable);
                    BookmarkController.this.alertIcon.setImage(this.reachable ? null : IconCache.iconNamed("alert.tiff"));
                }
            });
        } else {
            this.alertIcon.setImage(IconCache.iconNamed("alert.tiff"));
            this.alertIcon.setEnabled(false);
        }
    }

    public void portInputDidEndEditing(NSNotification sender) {
        try {
            this.host.setPort(Integer.parseInt(this.portField.stringValue()));
        }
        catch (NumberFormatException e) {
            this.host.setPort(-1);
        }
        this.itemChanged();
        this.init();
        this.reachable();
    }

    public void pathInputDidChange(NSNotification sender) {
        this.host.setDefaultPath(this.pathField.stringValue());
        this.itemChanged();
        this.init();
    }

    public void nicknameInputDidChange(NSNotification sender) {
        this.host.setNickname(this.nicknameField.stringValue());
        this.itemChanged();
        this.init();
    }

    public void usernameInputDidChange(NSNotification sender) {
        this.host.getCredentials().setUsername(this.usernameField.stringValue());
        this.itemChanged();
        this.init();
    }

    public void anonymousCheckboxClicked(NSButton sender) {
        if (sender.state() == 1) {
            this.host.getCredentials().setUsername(Preferences.instance().getProperty("connection.login.anon.name"));
        }
        if (sender.state() == 0) {
            if (Preferences.instance().getProperty("connection.login.name").equals(Preferences.instance().getProperty("connection.login.anon.name"))) {
                this.host.getCredentials().setUsername("");
            } else {
                this.host.getCredentials().setUsername(Preferences.instance().getProperty("connection.login.name"));
            }
        }
        this.itemChanged();
        this.init();
    }

    public void webURLInputDidChange(NSNotification sender) {
        this.host.setWebURL(this.webURLField.stringValue());
        this.updateFavicon();
        this.itemChanged();
    }

    public void commentInputDidChange(NSNotification sender) {
        this.host.setComment(this.commentField.textStorage().string());
        this.itemChanged();
    }

    private void itemChanged() {
        BookmarkCollection.defaultCollection().collectionItemChanged(this.host);
    }

    private void init() {
        this.window.setTitle(this.host.getNickname());
        this.updateField(this.hostField, this.host.getHostname());
        this.hostField.setEnabled(this.host.getProtocol().isHostnameConfigurable());
        this.hostField.cell().setPlaceholderString(this.host.getProtocol().getDefaultHostname());
        this.updateField(this.nicknameField, this.host.getNickname());
        String url = StringUtils.isNotBlank((String)this.host.getDefaultPath()) ? this.host.toURL() + Path.normalize((String)this.host.getDefaultPath()) : this.host.toURL();
        this.urlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create(NSMutableAttributedString.create(url, TRUNCATE_MIDDLE_ATTRIBUTES), url));
        this.updateField(this.portField, String.valueOf(this.host.getPort()));
        this.portField.setEnabled(this.host.getProtocol().isHostnameConfigurable());
        this.updateField(this.pathField, this.host.getDefaultPath());
        this.updateField(this.usernameField, this.host.getCredentials().getUsername());
        this.usernameField.cell().setPlaceholderString(this.host.getProtocol().getUsernamePlaceholder());
        this.usernameField.setEnabled(!this.host.getCredentials().isAnonymousLogin());
        this.anonymousCheckbox.setEnabled(this.host.getProtocol().isAnonymousConfigurable());
        this.anonymousCheckbox.setState(this.host.getCredentials().isAnonymousLogin() ? 1 : 0);
        this.protocolPopup.selectItemWithTitle(this.host.getProtocol().getDescription());
        if (null == this.host.getMaxConnections()) {
            this.transferPopup.selectItemWithTitle(DEFAULT);
        } else {
            this.transferPopup.selectItemWithTitle(this.host.getMaxConnections() == 1 ? TRANSFER_BROWSERCONNECTION : TRANSFER_NEWCONNECTION);
        }
        this.encodingPopup.setEnabled(this.host.getProtocol().isEncodingConfigurable());
        this.connectmodePopup.setEnabled(this.host.getProtocol().isConnectModeConfigurable());
        if (this.host.getProtocol().isConnectModeConfigurable()) {
            if (null == this.host.getFTPConnectMode()) {
                this.connectmodePopup.selectItemWithTitle(DEFAULT);
            } else if (this.host.getFTPConnectMode().equals(FTPConnectMode.PASV)) {
                this.connectmodePopup.selectItemWithTitle(CONNECTMODE_PASSIVE);
            } else if (this.host.getFTPConnectMode().equals(FTPConnectMode.PORT)) {
                this.connectmodePopup.selectItemWithTitle(CONNECTMODE_ACTIVE);
            }
        }
        this.pkCheckbox.setEnabled(this.host.getProtocol().equals((Object)Protocol.SFTP));
        if (this.host.getCredentials().isPublicKeyAuthentication()) {
            this.pkCheckbox.setState(1);
            this.updateField(this.pkLabel, this.host.getCredentials().getIdentity().getAbbreviatedPath());
            this.pkLabel.setTextColor(NSColor.textColor());
        } else {
            this.pkCheckbox.setState(0);
            this.pkLabel.setStringValue(Locale.localizedString((String)"No private key selected"));
            this.pkLabel.setTextColor(NSColor.disabledControlTextColor());
        }
        this.webURLField.setEnabled(this.host.getProtocol().isWebUrlConfigurable());
        String webURL = this.host.getWebURL();
        this.webUrlImage.setToolTip(webURL);
        this.updateField(this.webURLField, this.host.getDefaultWebURL().equals(webURL) ? null : webURL);
        this.updateField(this.commentField, this.host.getComment());
        this.timezonePopup.setEnabled(!this.host.getProtocol().isUTCTimezone());
        if (null == this.host.getTimezone()) {
            if (this.host.getProtocol().isUTCTimezone()) {
                this.timezonePopup.setTitle(UTC.getID());
            } else if (Preferences.instance().getBoolean("ftp.timezone.auto")) {
                this.timezonePopup.setTitle(AUTO);
            } else {
                this.timezonePopup.setTitle(TimeZone.getTimeZone(Preferences.instance().getProperty("ftp.timezone.default")).getID());
            }
        } else {
            this.timezonePopup.setTitle(this.host.getTimezone().getID());
        }
    }

    public static class Factory {
        private static final Map<Host, BookmarkController> open = new HashMap<Host, BookmarkController>();

        public static BookmarkController create(final Host host) {
            if (open.containsKey(host)) {
                return open.get(host);
            }
            BookmarkController c = new BookmarkController(host){

                public void windowWillClose(NSNotification notification) {
                    super.windowWillClose(notification);
                    open.remove(host);
                }
            };
            open.put(host, c);
            return c;
        }
    }
}

