/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Preferences;
import ch.cyberduck.ui.cocoa.SheetController;
import ch.cyberduck.ui.cocoa.WindowController;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSView;
import ch.cyberduck.ui.cocoa.application.NSWindow;
import ch.cyberduck.ui.cocoa.foundation.NSEnumerator;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSRect;

public abstract class AlertController
extends SheetController {
    protected static Logger log = Logger.getLogger(AlertController.class);
    protected NSAlert alert;

    public AlertController(WindowController parent, NSAlert alert) {
        this(parent, alert, 0);
    }

    public AlertController(WindowController parent, NSAlert alert, int style) {
        super(parent);
        this.alert = alert;
        this.alert.setAlertStyle(style);
        this.alert.setDelegate(this.id());
    }

    public void setAccessoryView(NSView view) {
        view.setFrame(new NSRect(300.0, view.frame().size.height.floatValue()));
        this.alert.setAccessoryView(view);
    }

    protected void beginSheetImpl() {
        NSObject button;
        this.parent.window().makeKeyAndOrderFront(null);
        this.alert.layout();
        NSEnumerator buttons = this.alert.buttons().objectEnumerator();
        while ((button = buttons.nextObject()) != null) {
            NSButton b = Rococoa.cast(button, NSButton.class);
            b.setTarget(this.id());
            b.setAction(Foundation.selector("closeSheet:"));
        }
        this.alert.beginSheet(this.parent.window(), this.id(), Foundation.selector("alertDidEnd:returnCode:contextInfo:"), null);
        sheetRegistry.add(this);
    }

    protected void setTitle(String title) {
        this.alert.setMessageText(title);
    }

    protected void setMessage(String message) {
        this.alert.setInformativeText(message);
    }

    public void alertDidEnd_returnCode_contextInfo(NSAlert alert, int returnCode, ID contextInfo) {
        this.sheetDidClose_returnCode_contextInfo(alert.window(), returnCode, contextInfo);
    }

    protected int getCallbackOption(NSButton selected) {
        if (selected.tag() == 1) {
            return 1;
        }
        if (selected.tag() == 0) {
            return 0;
        }
        if (selected.tag() == -1) {
            return -1;
        }
        throw new RuntimeException("Unexpected tag:" + selected.tag());
    }

    protected void help() {
        AlertController.openUrl(Preferences.instance().getProperty("website.help"));
    }

    public boolean alertShowHelp(NSAlert alert) {
        this.help();
        return true;
    }

    public NSWindow window() {
        return this.alert.window();
    }
}

