/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractCollectionListener;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.AbstractTableDelegate;
import ch.cyberduck.ui.cocoa.ListDataSource;
import ch.cyberduck.ui.cocoa.TaskController;
import ch.cyberduck.ui.cocoa.WindowController;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.application.NSCell;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import ch.cyberduck.ui.cocoa.application.NSTableView;
import ch.cyberduck.ui.cocoa.application.NSView;
import ch.cyberduck.ui.cocoa.application.NSWindow;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.threading.WindowMainAction;
import ch.cyberduck.ui.cocoa.view.ControllerCell;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.rococoa.ID;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.CGFloat;
import org.rococoa.cocoa.foundation.NSInteger;

public class ActivityController
extends WindowController {
    private static Logger log = Logger.getLogger(ActivityController.class);
    private static ActivityController instance = null;
    private final Map<BackgroundAction, TaskController> tasks = Collections.synchronizedMap(new LinkedHashMap());
    private final AbstractCollectionListener<BackgroundAction> backgroundActionListener = new AbstractCollectionListener<BackgroundAction>(){

        public void collectionItemAdded(final BackgroundAction action) {
            ActivityController.this.invoke((MainAction)new WindowMainAction(ActivityController.this){

                public void run() {
                    log.debug((Object)("collectionItemAdded:" + action));
                    ActivityController.this.tasks.put(action, new TaskController(action));
                    ActivityController.this.reload();
                }
            });
        }

        public void collectionItemRemoved(final BackgroundAction action) {
            ActivityController.this.invoke((MainAction)new WindowMainAction(ActivityController.this){

                public void run() {
                    log.debug((Object)("collectionItemRemoved:" + action));
                    TaskController controller = (TaskController)((Object)ActivityController.this.tasks.remove(action));
                    if (null == controller) {
                        return;
                    }
                    controller.invalidate();
                    ActivityController.this.reload();
                }
            });
        }
    };
    private final TableColumnFactory tableColumnsFactory = new TableColumnFactory();
    private NSTableView table;
    private ListDataSource model;
    private AbstractTableDelegate<TaskController> delegate;
    private final NSCell prototype = ControllerCell.controllerCell();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActivityController instance() {
        NSApplication nSApplication = NSApplication.sharedApplication();
        synchronized (nSApplication) {
            if (null == instance) {
                instance = new ActivityController();
            }
            return instance;
        }
    }

    private ActivityController() {
        this.loadBundle();
        this.init();
    }

    protected void invalidate() {
        BackgroundActionRegistry.global().removeListener(this.backgroundActionListener);
        this.table.setDataSource(null);
        this.table.setDelegate(null);
        super.invalidate();
    }

    private void init() {
        BackgroundAction[] actions;
        BackgroundActionRegistry.global().addListener(this.backgroundActionListener);
        for (BackgroundAction action : actions = (BackgroundAction[])BackgroundActionRegistry.global().toArray((Object[])new BackgroundAction[BackgroundActionRegistry.global().size()])) {
            this.tasks.put(action, new TaskController(action));
        }
        this.reload();
    }

    private void reload() {
        while (this.table.subviews().count().intValue() > 0) {
            Rococoa.cast(this.table.subviews().lastObject(), NSView.class).removeFromSuperviewWithoutNeedingDisplay();
        }
        this.table.reloadData();
    }

    public void setWindow(NSWindow window) {
        window.setTitle(Locale.localizedString((String)"Activity"));
        super.setWindow(window);
    }

    public boolean isSingleton() {
        return true;
    }

    public void setTable(NSTableView table) {
        this.table = table;
        this.table.setRowHeight(new CGFloat(42.0));
        this.model = new ListDataSource(){

            public NSInteger numberOfRowsInTableView(NSTableView view) {
                return new NSInteger(ActivityController.this.tasks.size());
            }

            public NSObject tableView_objectValueForTableColumn_row(NSTableView view, NSTableColumn tableColumn, NSInteger row) {
                return null;
            }
        };
        this.table.setDataSource(this.model.id());
        this.delegate = new AbstractTableDelegate<TaskController>(){

            @Override
            public void enterKeyPressed(ID sender) {
            }

            @Override
            public void deleteKeyPressed(ID sender) {
            }

            @Override
            public String tooltip(TaskController c) {
                return null;
            }

            @Override
            public boolean tableView_shouldSelectRow(NSTableView view, NSInteger row) {
                return false;
            }

            @Override
            public void tableColumnClicked(NSTableView view, NSTableColumn tableColumn) {
            }

            @Override
            public void tableRowDoubleClicked(ID sender) {
            }

            @Override
            public void selectionDidChange(NSNotification notification) {
            }

            @Override
            protected boolean isTypeSelectSupported() {
                return false;
            }

            public void tableView_willDisplayCell_forTableColumn_row(NSTableView view, NSCell cell, NSTableColumn tableColumn, NSInteger row) {
                Collection values = ActivityController.this.tasks.values();
                int size = values.size();
                Rococoa.cast(cell, ControllerCell.class).setView(values.toArray(new TaskController[size])[size - 1 - row.intValue()].view());
            }
        };
        this.table.setDelegate(this.delegate.id());
        NSTableColumn c = this.tableColumnsFactory.create("Default");
        c.setMinWidth(80.0);
        c.setWidth(300.0);
        c.setResizingMask(1);
        c.setDataCell(this.prototype);
        this.table.addTableColumn(c);
        this.table.sizeToFit();
    }

    protected String getBundleName() {
        return "Activity";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableColumnFactory
    extends HashMap<String, NSTableColumn> {
        private TableColumnFactory() {
        }

        private NSTableColumn create(String identifier) {
            if (!this.containsKey(identifier)) {
                this.put(identifier, NSTableColumn.tableColumnWithIdentifier(identifier));
            }
            return (NSTableColumn)this.get(identifier);
        }
    }
}

